/*--------------------------------------------------------------------------*/
/* TESTMNTR.C                                                               */
/*                                                                          */
/* Test source for the Monitor program                                      */
/* This program was created for the sole purpose of testing PMMON.          */
/* Messages are sent to the PMMON window throught a dialog.                 */
/*                                                                          */
/* History:                                                                 */
/*    6/30/89  - Created by Peter Lee to aid in testing PMMON. (V1.0)       */
/*    1/22/90  - Added more examples of using PMMON. (v1.1)                 */
/*    2/27/90  - Added code to test new functions:                (v2.1)    */
/*               PMMON_Clear                                                */
/*               PMMON_Save                                                 */
/*               PMMON_AutoSave                                             */
/*    2/28/90  - Added code to test new function: PMMON_Pause     (v2.1)    */
/*    6/15/90  - Attempted to test PMMON_Msg and threads.                   */
/*               Currently it does not like threads due to code             */
/*               that is non-reentrant (vsprintf).  The new PMMON_Msg       */
/*               uses vsprintf.                                             */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#define  INCL_WIN                      // Include PM window funcions
#define  INCL_DOS

#include <os2.h>                       // OS/2 header file
#include <mt\stdio.h>                  // Standard I/O c functions
#include <mt\string.h>                 // C/2 string functions.

#include "pmmon.h"                     // Header file for PMMON functions
#include "tmmdefs.h"                   // TestMon definitions
#include "tmdlgs.h"                    // TestMon dialog header file
#include <thredman.h>

/***************************************************************************/
/*                                                                         */
/* Global variables                                                        */
/*                                                                         */
/***************************************************************************/
static HAB habTestMon = NULL;
static LONG lcxFullScreen, lcyFullScreen;
static HWND  hwndFrame = NULL;
static HWND  hwndClient = NULL;
static HMODULE hmoduleDLL = NULL;
static CHAR  szLogString[80];
static BOOL  fTimeText = FALSE;

/***************************************************************************/
/*                                                                         */
/* Prototype definitions                                                   */
/*                                                                         */
/***************************************************************************/
BOOL CreateTestMon ( void );
MRESULT EXPENTRY TestMonProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY SendTextDlgProc ( HWND hwndDlg, USHORT msg, MPARAM mp1, MPARAM mp2 );
void CheckMenuItem ( HWND hwnd, USHORT MenuID, BOOL bState );
VOID TestThread ( VOID );

/***************************************************************************/
/*                                                                         */
/* Main code                                                               */
/*                                                                         */
/***************************************************************************/
void cdecl main ( void )
{  /* main */

HMQ   hmqTestMon;                      // TestMon message queue
QMSG  qmsgTestMon;

   habTestMon = WinInitialize ( NULL );   // Initialize PM
   hmqTestMon = WinCreateMsgQueue ( habTestMon, NULL ); // Create msg queue

   /*----------------------------------------------------------------------*/
   /* First PMMON_Msg call, after the creation of the HAB and HMQ          */
   /*----------------------------------------------------------------------*/
   PMMON_Msg ("Testmon is up and running");

   /*----------------------------------------------------------------------*/
   /* Create the Testmon window and loop throught queue.                   */
   /*----------------------------------------------------------------------*/
   if (CreateTestMon()) {
      while (WinGetMsg ( habTestMon, &qmsgTestMon, NULL, 0,0 )) {
         WinDispatchMsg ( habTestMon, &qmsgTestMon );
      } /* endwhile */
      WinDestroyWindow ( hwndFrame );
   } /* endif */

   WinDestroyMsgQueue ( hmqTestMon );
   WinTerminate ( habTestMon );
}  /* main */

/***************************************************************************/
/*                                                                         */
/* CreateTestMon: Creates the TestMon main window.                         */
/*                                                                         */
/***************************************************************************/
BOOL CreateTestMon ( void )
{  /* CreateTestMon */

ULONG ulCreateFlags;
SHORT sXPos, sYPos, sWidth, sHeight;
CHAR  szTitle[80];
RECTL  rcl;
SHORT  scx,scy;
CHAR  szDebug[120];

   /*----------------------------------------------------------------------*/
   /* Using PMMON_Msg like the following can be useful in following calling*/
   /* sequences.  A matching call can be used prior to leaving the routine.*/
   /*----------------------------------------------------------------------*/
   PMMON_Msg ("Entering CreateTestMon **** Start ****");

   if (WinRegisterClass ( habTestMon,
                           (PSZ)"PalTestMon",
                           TestMonProc,
                           CS_SIZEREDRAW,
                           0L
                         )) {
      PMMON_Msg ("Class Registered OK");
   } else {
      PMMON_Msg ("Unable to register TestMon class");
      return ((BOOL)FALSE);
   } /* endif */

   ulCreateFlags = FCF_STANDARD
                   & ~FCF_ACCELTABLE      // No accel table in resource
                   & ~FCF_SHELLPOSITION   // Don't allow PM to position
                   ;

   hwndFrame = WinCreateStdWindow ( HWND_DESKTOP,
                         0L,              // frame-window style = none
                         &ulCreateFlags,  // creation flags
                         (PSZ)"PalTestMon",
                         (PSZ)"",         // Title = none
                         NULL,            // client-window style
                         NULL,            // Resources in exe
                         ID_TESTMON,
                         &hwndClient
                         );
   if (hwndFrame == NULL) {
      PMMON_Msg ("Unable to Create standard window for Testmon");
      return ((BOOL)FALSE);
   } else {
      PMMON_Msg ("Window created successfully");
   } /* endif */

   /* Set the title for monitor */
   WinLoadString ( habTestMon, NULL, IDS_TESTMON_TITLE, 80, szTitle );
   WinSetWindowText ( hwndFrame, szTitle );

   lcxFullScreen = WinQuerySysValue ( HWND_DESKTOP, SV_CXSCREEN );
   lcyFullScreen = WinQuerySysValue ( HWND_DESKTOP, SV_CYSCREEN );

   sXPos = (SHORT)lcxFullScreen - TESTMON_WIDTH;
   sYPos = (SHORT)lcyFullScreen - TESTMON_HEIGHT;
   sWidth = TESTMON_WIDTH;
   sHeight = TESTMON_HEIGHT;

   /*----------------------------------------------------------------------*/
   /* Example of using sprintf with PMMON.                                 */
   /*----------------------------------------------------------------------*/
   sprintf (szDebug, "Starting position for Testmon (x,y)=(%i,%i) (cx,cy)=(%i,%i)",
                      sXPos, sYPos, sWidth, sHeight );
   PMMON_Msg (szDebug);

   WinSetWindowPos ( hwndFrame,
                     NULL,
                     sXPos,
                     sYPos,
                     sWidth,
                     sHeight,
                     SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_SHOW
                   );
   WinQueryWindowRect ( hwndClient, &rcl );
   scx = (SHORT)(rcl.xRight - rcl.xLeft);
   scy = (SHORT)(rcl.yTop - rcl.yBottom);

   PMMON_Msg ("Leaving CreateTestMon: ***** End *****");

   return ((BOOL)TRUE);
}  /* CreateTestMon */


/***************************************************************************/
/*                                                                         */
/* TestMonProc : TestMon window proc                                       */
/*                                                                         */
/***************************************************************************/
MRESULT EXPENTRY TestMonProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{  /* TestMonProc */

USHORT usCmd;
static USHORT usCounter = 0;
CHAR   szTemp[120];

/* variables used for WinBeginPaint */
HPS    hps;
RECTL  rcl;
static CHAR   szWindowText[120];

DATETIME dt;
static SEL   sel;

   switch (msg) {
   case WM_CREATE:
      /*-------------------------------------------------------------------*/
      /* PMMON can be used to indicate when a message has been received.   */
      /*-------------------------------------------------------------------*/
      PMMON_Msg ("WM_CREATE msg received");
      WinLoadString (  habTestMon, NULL, IDS_TESTMON_TEXT, 120, szWindowText );
      break;
   case WM_COMMAND:
      usCmd = SHORT1FROMMP ( mp1 );
      switch (usCmd) {
      case IDM_EXIT_YES:
         WinPostMsg ( hwnd, WM_CLOSE, 0L, 0L );
         break;
      case IDM_SENDTEXT:
         WinDlgBox ( HWND_DESKTOP, HWND_DESKTOP, SendTextDlgProc, NULL, IDD_SENDTEXT_DLG, NULL );
         break;
      case IDM_SENDTEXT_VAR:
         DosGetDateTime ( &dt );
         PMMON_Msg ("Variable Test @ %u:%u:%u on %u/%u/%u", dt.hours, dt.minutes, dt.seconds,
                     dt.month, dt.day, dt.year );
         break;
      case IDM_TEST_TIMED:             // Start/Stop timer messages
         if (fTimeText) {
            fTimeText = FALSE;
            CheckMenuItem ( hwnd, IDM_TEST_TIMED, FALSE );
            WinStopTimer ( habTestMon, hwnd, 1 );
         } else {
            fTimeText = TRUE;
            CheckMenuItem ( hwnd, IDM_TEST_TIMED, TRUE );
            WinStartTimer ( habTestMon, hwnd, 1, 1000 );
            usCounter = 0;
         } /* endif */
         break;
      case IDM_TEST_CLEARAPI:          // Test PMMON_Clear API
         PMMON_Clear();
         break;
      case IDM_TEST_SAVEAPI:           // Test PMMON_Save API
         PMMON_Save ("SAVETEST.SAV");
         break;
      case IDM_TEST_AUTOSAVEAPI:       // Test PMMON_AutoSave API
         PMMON_AutoSave ("", 5);       // Use default filename
         break;
      case IDM_TEST_PAUSE:             // Test PMMON_Pause API
         PMMON_Pause ( TRUE );
         break;
      case IDM_TEST_RESUME:            // Test PMMON_Pause API
         PMMON_Pause ( FALSE );
         break;
      case IDM_TEST_SAVEAS:            // Test PMMO_Save (Force Autosave)
         PMMON_Save (NULL);
         break;

      /* The following item is used to test PMMON_Msg and Threads. Currently */
      /* it does not seem to work, so it will be commented out for the time  */
      /* being.  6/15/90 - PAL                                               */
//    case IDM_TEST_BEGINTHREAD:
//       StartAThread ( TestThread, &sel );
//       break;
      } /* endswitch */
      break;
   case WM_TIMER:
      sprintf (szTemp, "Line message %u", usCounter );
      PMMON_Msg (szTemp);
      usCounter++;
      break;
   case WM_ERASEBACKGROUND:
      return (MRESULT)TRUE;
      break;
   case WM_PAINT:
      hps = WinBeginPaint ( hwnd, NULL, &rcl );
       WinQueryWindowRect ( hwnd, &rcl );
       WinFillRect ( hps, &rcl, CLR_BACKGROUND );
       WinDrawText ( hps, 0xFFFF, szWindowText, &rcl, CLR_NEUTRAL, CLR_BACKGROUND,
                     DT_CENTER | DT_VCENTER | DT_ERASERECT | DT_WORDBREAK );
      WinEndPaint ( hps );
      break;
   default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
   } /* endswitch */

   return (MRESULT)FALSE;
}  /* TestMonProc */

/***************************************************************************/
/*                                                                         */
/* SendTextDlgProc: Dialog procedure for the send text dialog.             */
/*                                                                         */
/***************************************************************************/
MRESULT EXPENTRY SendTextDlgProc ( HWND hwndDlg, USHORT msg, MPARAM mp1, MPARAM mp2 )
{  /* SendTextDlgProc */

USHORT Cmd;
static BOOL fDlgChanged = FALSE;
static CHAR szText[80] = "";

   switch (msg) {
   case WM_INITDLG:
      /*-------------------------------------------------------------------*/
      /* PMMON can be used from within a dialog proc.                      */
      /*-------------------------------------------------------------------*/
      PMMON_Msg ("Starting dialog proc that sends text to PMMON");
      strcpy (szText,"");
      WinSetDlgItemText ( hwndDlg, IDD_SENDTEXT_ENTRY, szText );
      WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_SEND, BM_SETDEFAULT,
                          MPFROMSHORT((USHORT)FALSE), 0L );
      WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_CANCEL, BM_SETDEFAULT,
                          MPFROMSHORT((USHORT)TRUE), 0L );
      WinSetFocus ( HWND_DESKTOP, WinWindowFromID ( hwndDlg, IDD_SENDTEXT_ENTRY ));
      fDlgChanged = FALSE;
      break;
   case WM_COMMAND:
      Cmd = SHORT1FROMMP ( mp1 );
      switch (Cmd) {
      case IDD_SENDTEXT_SEND:
         WinQueryDlgItemText ( hwndDlg, IDD_SENDTEXT_ENTRY, 80, szLogString );
         /*----------------------------------------------------------------*/
         /* Here PMMON_Msg is used to send text directly to PMMON.         */
         /*----------------------------------------------------------------*/
         PMMON_Msg ( szLogString );
         fDlgChanged = FALSE;
         WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_SEND, BM_SETDEFAULT,
                             MPFROMSHORT((USHORT)FALSE), 0L );
         WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_CANCEL, BM_SETDEFAULT,
                             MPFROMSHORT((USHORT)TRUE), 0L );
         WinSetFocus ( HWND_DESKTOP, WinWindowFromID ( hwndDlg, IDD_SENDTEXT_ENTRY ));
         WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_ENTRY, EM_SETFIRSTCHAR,
                             MPFROMSHORT((USHORT)0),0L);
         WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_ENTRY, EM_SETSEL,
                             MPFROM2SHORT((USHORT) 0, (USHORT) strlen(szLogString)),
                             0L );

         break;
      case IDD_SENDTEXT_CANCEL:
         strcpy (szLogString,"");
         WinDismissDlg ( hwndDlg, FALSE );
         break;
      default:
         return WinDefDlgProc ( hwndDlg, msg, mp1, mp2 );
      } /* endswitch */
      break;
   case WM_CONTROL:
      switch (SHORT1FROMMP(mp1)) {
      case IDD_SENDTEXT_ENTRY:
         switch (SHORT2FROMMP(mp1)) {
         case EN_CHANGE:
            if (!fDlgChanged) {
               WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_SEND, BM_SETDEFAULT,
                                   MPFROMSHORT((USHORT)TRUE), 0L );
               WinSendDlgItemMsg ( hwndDlg, IDD_SENDTEXT_CANCEL, BM_SETDEFAULT,
                                   MPFROMSHORT((USHORT)FALSE), 0L );
               fDlgChanged = TRUE;
            } /* endif */
            break;
         } /* endswitch */
         break;
      } /* endswitch */
      break;
   default:
      return WinDefDlgProc ( hwndDlg, msg, mp1, mp2 );
   } /* endswitch */
}  /* SendTextDlgProc */
/* $PAGE */
/***************************************************************************/
/* CheckMenuItem                                                           */
/*                                                                         */
/* Check/UnChecks menu items given ID and hwnd of client.                  */
/*                                                                         */
/* 12/18/89 - Copied from KBEDITOR                                         */
/*                                                                         */
/***************************************************************************/
void CheckMenuItem ( HWND hwnd, USHORT MenuID, BOOL bState )
{  /* CheckMenuItem */

HWND hwndParent;

   hwndParent = WinQueryWindow ( hwnd, QW_PARENT, FALSE );
   if (bState) {
      /* Turn menu item on */
      WinSendMsg ( WinWindowFromID ( hwndParent, FID_MENU ),
                   MM_SETITEMATTR,
                   MPFROM2SHORT ( MenuID, TRUE ),
                   MPFROM2SHORT ( MIA_CHECKED, MIA_CHECKED )
                 );
   } else {
      WinSendMsg ( WinWindowFromID ( hwndParent, FID_MENU ),
                   MM_SETITEMATTR,
                   MPFROM2SHORT ( MenuID, TRUE ),
                   MPFROM2SHORT ( MIA_CHECKED, FALSE )
                 );
   } /* endif */
}  /* CheckMenuItem */

/*****************************************************************************/
/* TestThread()                                                              */
/*                                                                           */
/* This function is being used to test PMMON_Msg in a thread.  Unfortunately */
/* PMMON_Msg and threads cannot coexist.                                     */
/*                                                                           */
/* 6/14/90  - Created to test PMMON_Msg and Threads.                         */
/* 6/15/90  - Commented out temporarily.  It seem that PMMON_Msg and threads */
/*            cannot coexist.  Until I can find a solution this will remain  */
/*            as a comment.                                                  */
/*                                                                           */
/*****************************************************************************/
// VOID TestThread ( VOID )
// {  /* TestThread */
//
// SHORT x;
//    DosBeep(2000,75);
//    for (x=0; x<10; x++) {
//       PMMON_Msg2 ("TestThread loop count" );
//    } /* endfor */
//    DosBeep(4000,100);
// }
